IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_IdentifDNI') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_IdentifDNI
END
GO

CREATE FUNCTION [dbo].[CF_IdentifDNI](@pDato VARCHAR(100))
RETURNS INT
AS

BEGIN

	DECLARE @Id_Cliente					INT
	DECLARE @Flag_Tipo_DNI				TINYINT
	DECLARE @Flag_Formato_Valido_Doc	INT
	DECLARE @Doc_Escaneado				VARCHAR(20)
	DECLARE @Doc_Nro					BIGINT
	DECLARE @Long_Dato					INT
	DECLARE @Flag_Es_Numerico			TINYINT

	IF(ISNULL(@pDato, '') = '')
	BEGIN
		SET @Id_Cliente = 0
		RETURN @Id_Cliente
	END

	SET @Long_Dato			= LEN(@pDato)
	SET @Flag_Es_Numerico	= dbo.CF_IsNumeric(@pDato)

	IF(@Long_Dato > 50)
	BEGIN
		IF(ISNULL(dbo.SF_CortarCadena(@pDato, '"', 4), '') IN ('F', 'M') OR ISNULL(dbo.SF_CortarCadena(@pDato, '"', 9), '') IN ('F', 'M'))
		BEGIN
			IF(ISNULL(dbo.SF_CortarCadena(@pDato, '"', 4), '') IN ('F', 'M'))
			BEGIN
				SET @Flag_Tipo_DNI = 1 /*Formato Nuevo*/
			END
			ELSE
			BEGIN
				SET @Flag_Tipo_DNI = 2 /*Formato Viejo*/
			END
		END
		ELSE
		BEGIN
			/*Formato NO valido*/
			SET @Flag_Tipo_DNI = 0
		END

		/*Formato Nuevo*/
		IF(@Flag_Tipo_DNI = 1) 
		BEGIN
			SET @Doc_Escaneado				= (SELECT dbo.SF_CortarCadena(@pDato, '"', 5))
			SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'M', '')
			SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'F', '')
			SET @Flag_Formato_Valido_Doc	= (SELECT ISNUMERIC(@Doc_Escaneado))

			IF(@Flag_Formato_Valido_Doc = 1)
			BEGIN
				SET @Doc_Nro					= @Doc_Escaneado
				SET @Id_Cliente					= (SELECT TOP 1 ISNULL(Id_Cliente, 0) FROM Clientes WHERE Doc_Nro = @Doc_Nro ORDER BY Activo DESC, Id_Cliente DESC)
			END
			ELSE
			BEGIN
				SET @Id_Cliente = 0
			END
		END

		/*Formato Viejo*/
		IF(@Flag_Tipo_DNI = 2) 
		BEGIN
			SET @Doc_Escaneado				= (SELECT dbo.SF_CortarCadena(@pDato, '"', 2))
			SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'M', '')
			SET @Doc_Escaneado				= REPLACE(@Doc_Escaneado, 'F', '')
			SET @Flag_Formato_Valido_Doc	= (SELECT ISNUMERIC(@Doc_Escaneado))

			IF(@Flag_Formato_Valido_Doc = 1)
			BEGIN
				SET @Doc_Nro					= @Doc_Escaneado
				SET @Id_Cliente					= (SELECT TOP 1 ISNULL(Id_Cliente, 0) FROM Clientes WHERE Doc_Nro = @Doc_Nro ORDER BY Activo DESC, Id_Cliente DESC)
			END
			ELSE
			BEGIN
				SET @Id_Cliente = 0
			END
		END

		/*Formato NO valido*/
		IF(@Flag_Tipo_DNI = 0) 
		BEGIN
			SET @Id_Cliente = 0
		END
		
	END


RETURN @Id_Cliente

END